package creditExample;

import id3.*;

public class Test {

	public static void main(String[] args) {

		ExampleSet exampleSet = new ExampleSet();
		try{
			// Example 1
			CreditExample example = new CreditExample(CreditExample.HIGH, 
					new CreditHistoryProperty(CreditHistoryProperty.BAD),
					new DebtProperty(DebtProperty.HIGH),
					new CollateralProperty(CollateralProperty.NONE),
					new IncomeProperty(IncomeProperty.$0_TO_$15K)
					);
			exampleSet.addExample(example);
	
			// Example 2
			example = new CreditExample(CreditExample.HIGH, 
					new CreditHistoryProperty(CreditHistoryProperty.UNKNOWN),
					new DebtProperty(DebtProperty.HIGH),
					new CollateralProperty(CollateralProperty.NONE),
					new IncomeProperty(IncomeProperty.$15K_TO_$35K)
					);
			exampleSet.addExample(example);

			// Example 3
			example = new CreditExample(CreditExample.MODERATE, 
					new CreditHistoryProperty(CreditHistoryProperty.UNKNOWN),
					new DebtProperty(DebtProperty.LOW),
					new CollateralProperty(CollateralProperty.NONE),
					new IncomeProperty(IncomeProperty.$15K_TO_$35K)
					);
			exampleSet.addExample(example); 

			// Example 4
			example = new CreditExample(CreditExample.HIGH, 
					new CreditHistoryProperty(CreditHistoryProperty.UNKNOWN),
					new DebtProperty(DebtProperty.LOW),
					new CollateralProperty(CollateralProperty.NONE),
					new IncomeProperty(IncomeProperty.$0_TO_$15K)
					);
			exampleSet.addExample(example);
	
			// Example 5
			example = new CreditExample(CreditExample.LOW, 
					new CreditHistoryProperty(CreditHistoryProperty.UNKNOWN),
					new DebtProperty(DebtProperty.LOW),
					new CollateralProperty(CollateralProperty.NONE),
					new IncomeProperty(IncomeProperty.OVER_$35K)
					);
			exampleSet.addExample(example);
	
			// Example 6
			example = new CreditExample(CreditExample.LOW, 
					new CreditHistoryProperty(CreditHistoryProperty.UNKNOWN),
					new DebtProperty(DebtProperty.LOW),
					new CollateralProperty(CollateralProperty.ADEQUATE),
					new IncomeProperty(IncomeProperty.OVER_$35K)
					);
			exampleSet.addExample(example);
	
			// Example 7
			example = new CreditExample(CreditExample.HIGH, 
					new CreditHistoryProperty(CreditHistoryProperty.BAD),
					new DebtProperty(DebtProperty.LOW),
					new CollateralProperty(CollateralProperty.NONE),
					new IncomeProperty(IncomeProperty.$0_TO_$15K)
					);
			exampleSet.addExample(example);
	
			// Example 8
			example = new CreditExample(CreditExample.MODERATE, 
					new CreditHistoryProperty(CreditHistoryProperty.BAD),
					new DebtProperty(DebtProperty.LOW),
					new CollateralProperty(CollateralProperty.ADEQUATE),
					new IncomeProperty(IncomeProperty.OVER_$35K)
					);
			exampleSet.addExample(example); 
	
			// Example 9
			example = new CreditExample(CreditExample.LOW, 
					new CreditHistoryProperty(CreditHistoryProperty.GOOD),
					new DebtProperty(DebtProperty.LOW),
					new CollateralProperty(CollateralProperty.NONE),
					new IncomeProperty(IncomeProperty.OVER_$35K)
					);
			exampleSet.addExample(example);
	
			// Example 10
			example = new CreditExample(CreditExample.LOW, 
					new CreditHistoryProperty(CreditHistoryProperty.GOOD),
					new DebtProperty(DebtProperty.HIGH),
					new CollateralProperty(CollateralProperty.ADEQUATE),
					new IncomeProperty(IncomeProperty.OVER_$35K)
					);
			exampleSet.addExample(example);
	
			// Example 11
			example = new CreditExample(CreditExample.HIGH, 
					new CreditHistoryProperty(CreditHistoryProperty.GOOD),
					new DebtProperty(DebtProperty.HIGH),
					new CollateralProperty(CollateralProperty.NONE),
					new IncomeProperty(IncomeProperty.$0_TO_$15K)
					);
			exampleSet.addExample(example);
	
			// Example 12
			example = new CreditExample(CreditExample.MODERATE, 
					new CreditHistoryProperty(CreditHistoryProperty.GOOD),
					new DebtProperty(DebtProperty.HIGH),
					new CollateralProperty(CollateralProperty.NONE),
					new IncomeProperty(IncomeProperty.$15K_TO_$35K)
					);
			exampleSet.addExample(example);
	
			// Example 13
			example = new CreditExample(CreditExample.LOW, 
					new CreditHistoryProperty(CreditHistoryProperty.GOOD),
					new DebtProperty(DebtProperty.HIGH),
					new CollateralProperty(CollateralProperty.NONE),
					new IncomeProperty(IncomeProperty.OVER_$35K)
					);
			exampleSet.addExample(example); 
	
			// Example 14
			example = new CreditExample(CreditExample.HIGH, 
					new CreditHistoryProperty(CreditHistoryProperty.BAD),
					new DebtProperty(DebtProperty.HIGH),
					new CollateralProperty(CollateralProperty.NONE),
					new IncomeProperty(IncomeProperty.$15K_TO_$35K)
					);
			exampleSet.addExample(example);
	

			
			System.out.println();
			System.out.println("example count = " + exampleSet.getSize());
			
			for(int i = 0; i < exampleSet.getSize(); i++){
				AbstractExample e = exampleSet.getExample(i);
				System.out.println("Example " + i + ": " + e.toString());
			}

			System.out.println();
			System.out.println(exampleSet.getCategories());
			
			System.out.println();
			System.out.println(exampleSet.getPropertyNames());
			AbstractDecisionTreeNode tree = new InformationTheoreticDecisionTreeNode(exampleSet);
			
			tree.induceTree(exampleSet, exampleSet.getPropertyNames());
			tree.printTree(0);

			
			example = new CreditExample(
					new CreditHistoryProperty(CreditHistoryProperty.BAD),
					new DebtProperty(DebtProperty.HIGH),
					new CollateralProperty(CollateralProperty.ADEQUATE),
					new IncomeProperty(IncomeProperty.$15K_TO_$35K)
					);
			
			String cat = tree.categorize(example);

			System.out.println();
			System.out.println(cat);
			

			 example = new CreditExample(
					new CreditHistoryProperty(CreditHistoryProperty.GOOD),
					new DebtProperty(DebtProperty.LOW),
					new CollateralProperty(CollateralProperty.ADEQUATE),
					new IncomeProperty(IncomeProperty.$0_TO_$15K)
					);
			
			cat = tree.categorize(example);

			System.out.println();
			System.out.println(cat);
			
		}
		catch (Exception e) {System.out.println("Exception"+ e);}
   }

}
